/* D2D 3.0 Childhood Immunization Query
*  For use against P&P Data Systems CIS (Clinic Information System) MSSQL Backends
*  
*  Example Usage:
*   SELECT * from [Reporting].dbo.ChildhoodImmunizationReport('2018-01-01')
*   (Where 2018-01-01 is the start of the Fiscal year for which to run the report)
*
*  Setup Instructions:
*   1) Open this SQL file in SQL Server Management Studio
*   2) Select the database to create the stored procedures in
*   3) Select and execute each CREATE FUNCTION statement seperately
*
*  Update Instructions:
*   1) Select the database that contains the stored procedures
*   2) Replace all CREATE FUNCTION instances in the statements below with ALTER FUNCTION
*   3) Select and execute each ALTER FUNCTION statement seperately
*
*  Custom Environments:
*   In environments where non-standard CIS database names are being used, you will need to replace the following database references appropriately:
*   [MEDREC]	=> Should point to CIS EMR database (normally called MEDREC)
*   [PATIENT]	=> Should point to CIS PATIENT database (normally called PATIENT)
*   [SETUPS]	=> Should point to the CIS SETUPS database (normally called SETUPS)
*   [Reporting] => Should point to whichever database you used the CREATE/ALTER FUNCTION statements on
*/

/* Main Childhood Immunization Report function */ 
 
CREATE FUNCTION [dbo].[ChildhoodImmunizationReport] (@FiscalYear DATE) RETURNS TABLE AS RETURN 
	SELECT TOP 100 PERCENT P.[System ID], P.[Name First], P.[Name Last], P.[Name Initial], P.[Birth Date], (FLOOR(DATEDIFF("YY",p.[Birth Date],GETDATE()))) AS Age,    P.Pvdr, Dr.NameLast AS ProviderLastName, Dr.NameFirst AS ProviderFirstName,     MM.[Done Date] AS [1], Pe.Column2 AS [2], Pe.Column3 AS [3], Pe.Column4 AS [4], Pe.Column5 AS [5],     Pr.Column6 AS [6], Pr.Column7 AS [7], Pr.Column8 AS [8], Me.[Done Date] AS [9], V.[Done Date] AS [10], R.[Done Date] AS [11],    Dx.[Last Date Entered]   FROM [Patient].dbo.[Demographic] P LEFT OUTER JOIN    [SETUPS].dbo.Provider Dr ON     P.Pvdr = Dr.[No] LEFT OUTER JOIN    [Reporting].dbo.GetImmunization_MMR() MM ON     P.[System ID] = MM.[Patient ID] LEFT OUTER JOIN    [Reporting].dbo.GetImmunization_Penta() Pe ON     P.[System ID] = Pe.[Patient ID] LEFT OUTER JOIN    [Reporting].dbo.GetImmunization_Prevnar() Pr ON     P.[System ID] = Pr.[Patient ID] LEFT OUTER JOIN    [Reporting].dbo.GetImmunization_Menjudate() Me ON     P.[System ID] = Me.[Patient ID] LEFT OUTER JOIN    [Reporting].dbo.GetImmunization_Varivax() V ON     P.[System ID] = V.[Patient ID] LEFT OUTER JOIN [Reporting].dbo.GetImmunization_Rotarix () R ON     P.[System ID] = R.[Patient ID] LEFT OUTER JOIN 
	(
		SELECT PND.[Patient ID], MAX(PND.[Date Entered]) AS [Last Date Entered] FROM [MEDREC].dbo.[Progress Notes Diagnosis] PND WHERE PND.[Unique #] = 879  -- chickenpox Dx
		GROUP BY PND.[Patient ID]
	) Dx ON     P.[System ID] = Dx.[Patient ID]   WHERE P.[Birth Date] BETWEEN DATEADD(MONTH, -42, @FiscalYear) AND DATEADD(MONTH, -30, @FiscalYear) ORDER BY ProviderLastName, ProviderFirstName, P.[Name Last], P.[Name First], P.[Birth Date] 
 
/* MMR function */ 
CREATE FUNCTION dbo.GetImmunization_MMR() RETURNS TABLE AS  RETURN    SELECT I.[Patient ID], MAX(I.[Done Date]) AS [Done Date]   FROM [MEDREC].dbo.Immunizations I   WHERE I.Name LIKE '%MMR%'   GROUP BY I.[Patient ID] 

/* Penta function */ 
CREATE FUNCTION dbo.GetImmunization_Penta() RETURNS TABLE AS  RETURN    SELECT Penta.[Patient ID], Penta.[1] AS Column2, Penta.[2] AS Column3, Penta.[3] AS Column4, Penta.[4] AS Column5   FROM (    SELECT I.*    FROM (     SELECT I.[Patient ID], I.[Done Date],      RANK() OVER (PARTITION BY I.[Patient ID] ORDER BY I.[Done Date] DESC, I.xID DESC) RowNum     FROM [MEDREC].dbo.Immunizations I     WHERE I.Name LIKE '%Penta%' OR       I.Name LIKE '%Pediacel%'    ) I 
   WHERE I.RowNum <= 4   ) I   PIVOT    (    MAX(I.[Done Date])    FOR I.RowNum IN ([1], [2], [3], [4])   ) AS Penta
 
/* Prevnar function */ 
CREATE FUNCTION dbo.GetImmunization_Prevnar() RETURNS TABLE AS  RETURN    SELECT Prevnar.[Patient ID], Prevnar.[1] AS Column6, Prevnar.[2] AS Column7, Prevnar.[3] AS Column8   FROM (    SELECT I.*    FROM (     SELECT I.[Patient ID], I.[Done Date],      RANK() OVER (PARTITION BY I.[Patient ID] ORDER BY I.[Done Date] DESC, I.xID DESC) RowNum     FROM [MEDREC].dbo.Immunizations I     WHERE I.Name LIKE '%Prevnar%' OR       I.Name LIKE '%Synflorix%'    ) I    WHERE I.RowNum <= 3   ) I   PIVOT    (    MAX(I.[Done Date])    FOR I.RowNum IN ([1], [2], [3])   ) AS Prevnar 
 
/* Menjudate function */ 
CREATE FUNCTION dbo.GetImmunization_Menjudate() 
RETURNS TABLE AS  RETURN    SELECT I.[Patient ID], MAX(I.[Done Date]) AS [Done Date]   FROM [MEDREC].dbo.Immunizations I   WHERE I.Name LIKE '%Menjugate%' OR    I.Name LIKE '%Neisvac C%'   GROUP BY I.[Patient ID] 
 
/* Varivax function */ 
CREATE FUNCTION dbo.GetImmunization_Varivax() RETURNS TABLE AS  RETURN    SELECT I.[Patient ID], MAX(I.[Done Date]) AS [Done Date]   FROM [MEDREC].dbo.Immunizations I   WHERE I.Name LIKE '%Varivax%' OR    I.Name LIKE '%Varilix%' OR    I.Name LIKE '%Varilax%' OR    I.Name LIKE '%Varilrix%'   GROUP BY I.[Patient ID] 
 
/* Rotarix function */
CREATE FUNCTION dbo.GetImmunization_Rotarix () RETURNS TABLE AS  RETURN    SELECT I.[Patient ID], MAX(I.[Done Date]) AS [Done Date]   FROM [MEDREC].dbo.Immunizations I   WHERE I.Name LIKE '%Rotarix%' GROUP BY I.[Patient ID]